/*****************************************************************************************************************************/

IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend')
BEGIN
	DROP TABLE EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend
END
--#TMP_CUST_PEND 
	CREATE TABLE EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend (CD_EMP		INT,
															 CD_FILIAL	INT,
															 CD_PROD	INT,
															 DT_PROC		DATETIME,
															 DT_PROC_FLUT	DATETIME,
															 DT_CAD			DATETIME
															 CONSTRAINT [PK_EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend] PRIMARY KEY CLUSTERED (CD_PROD,CD_FILIAL,CD_EMP)
															 ) 
go
	CREATE NONCLUSTERED INDEX IX_EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend_DT_PROC
		 ON EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend (DT_PROC); 
go

/****** Object:  StoredProcedure [dbo].[P_EST_FECHA_PROC_MOV_FILIAL_PENDENTE]    Script Date: 06/16/2012 13:50:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_FECHA_PROC_MOV_FILIAL_PENDENTE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_FECHA_PROC_MOV_FILIAL_PENDENTE]
GO
--EXECUTE P_EST_FECHA_PROC_MOV_FILIAL_PENDENTE 1, 5
--versao 2381

CREATE PROCEDURE [dbo].[P_EST_FECHA_PROC_MOV_FILIAL_PENDENTE](@CD_EMP INT=1,@CD_FILIAL	INT=0, 
																		@CD_PROD_PAR	INT =0,
																		@debug			tinyint=0)  
 
	AS

	
	SET TRANSACTION ISOLATION LEVEL READ COMMITTED;

	if @Debug=1
	begin
		PRINT	'****** Inicio - P_EST_FECHA_PROC_MOV_FILIAL_PENDENTE ******' + CONVERT(VARCHAR(8), GETDATE(), 108);
	end

	DECLARE @DT_FIM DATETIME, @DIA DATETIME
	DECLARE @CD_PROD AS INT
	DECLARE @DT_PROC_MIN AS DATETIME
	
	SET NOCOUNT ON
	SET @DT_FIM = CONVERT(VARCHAR,GETDATE(),112);

	--Analisando o periodo de corte do ultimo calculo de custo medio dos produtos
	--Pois pode haver produto com movimentacao muito antiga
	DECLARE @AGORA DATE
	DECLARE @DT_ANO_INI DATE
	DECLARE @ANO INT	 
	DECLARE @QTDE_DIAS_RETROAGE INT  

	DECLARE @DT_INI_DEL AS DATE;
	DECLARE @DT_FIM_DEL AS DATETIME;
	DECLARE @NMTBL AS VARCHAR(100), 
			@CMD AS VARCHAR(3000); 

	SET @QTDE_DIAS_RETROAGE = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP=1 AND CD_CHAVE='DIAS_ANTERIORES_REPROCESSAR_CUSTO_MEDIO'),90);  
   
	SET @AGORA = dateadd(day,@QTDE_DIAS_RETROAGE*-1,getdate())
	SET @ANO=YEAR(@AGORA)
    
	--Se estivermos em janeiro coloca a data inicio do ano ano passado...
	if month(@AGORA)=1
		SET @DT_ANO_INI = CONVERT(DATETIME, (CONVERT(VARCHAR, ((@ANO-1)*100+01)) + '01')) ;
	else
		SET @DT_ANO_INI = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+01)) + '01')) ;
	    

	IF DATEDIFF(day,@DT_ANO_INI,@AGORA)>@QTDE_DIAS_RETROAGE   
	begin  
		SET @QTDE_DIAS_RETROAGE =@QTDE_DIAS_RETROAGE *-1;  
		SELECT @DT_ANO_INI=DATEADD(DAY,@QTDE_DIAS_RETROAGE, @AGORA)  
	end  
	  

	IF EXISTS(SELECT  TOP 1 CD_EMP
			FROM 
				PRC_FILIAL  
			WHERE
				DT_INI_SISTEMA > @DT_ANO_INI
				AND CD_EMP=@CD_EMP
				AND CD_FILIAL=@CD_FILIAL)
	begin
		SELECT 
				@DT_ANO_INI=DT_INI_SISTEMA
			FROM 
				PRC_FILIAL  
			WHERE
				CD_EMP=@CD_EMP
				AND CD_FILIAL=@CD_FILIAL;
	end 

	Print 'Data inicial de processamento ' + convert(varchar,@DT_ANO_INI,112) + ' - time ' + convert(varchar,getdate(),108);
	---Implenta o corte pela data de fechamento de inventario.
	IF ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG 
									WHERE CD_EMP=1 
										AND CD_CHAVE = 'BLOQ_PROC_CUSTO_REG_INVENTARIO'),0) =1 BEGIN
		--Verifica bloqueio contbil 
		Print 'Verifica bloqueio contbil ' + convert(varchar,getdate(),108);
		SET @DT_ANO_INI =ISNULL((SELECT  MAX(DT_REF) 
					FROM 
						EST_PROD_INVENTARIO  
					WHERE 
						  CD_EMP=@CD_EMP
						AND CD_FILIAL=@CD_FILIAL),@DT_ANO_INI); 
	END

	 --SET @DT_ANO_INI= '20170101'
	--
	if @debug=1
	begin
		Print 'Insere custo das notas pendentes ' + convert(varchar,getdate(),108);
	end
/*************************************************************************************************************************/
	Declare @DiaCorte date = DATEADD(d, (- DATEPART(d, GETDATE()) + 1) , GETDATE());
	

	Set @Cmd= 'INSERT INTO EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE(CD_EMP,CD_FILIAL,CD_PROD,DT_PROC,DT_CAD,DT_PROC_ATUAL)
	SELECT 
		I.CD_EMP, 
		I.CD_FILIAL,
		I.CD_PROD CD_PROD, 
		MIN(E.DT_ENT) DT_PROC, 
		GETDATE() DT_CAD, 
		NULL DT_PROC_ATUAL 
	FROM
		EST_NF_ENT E WITH(NOLOCK)
		INNER JOIN EST_NF_ENT_IT I WITH(NOLOCK) ON 
		E.CD_EMP =I.CD_EMP AND
		E.CD_FILIAL =I.CD_FILIAL AND
		E.CD_NF =I.CD_NF and 
		E.DT_ENT = I.DT_ENT
		INNER JOIN GLB_MOV_OP O WITH(NOLOCK) ON 
		E.CD_NT_MOV =O.CD_MOV_OP 

		LEFT JOIN EST_FECHA_PROC_MOV M WITH(NOLOCK) ON 
		I.CD_EMP	= M.CD_EMP AND
		I.CD_FILIAL = M.CD_FILIAL AND
		I.CD_PROD	= M.CD_PROD
		AND M.DT_PROC = I.DT_ENT 

		LEFT JOIN EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE P WITH(NOLOCK) ON
		I.CD_EMP	= P.CD_EMP AND
		I.CD_FILIAL = P.CD_FILIAL AND
		I.CD_PROD	= P.CD_PROD
	WHERE
		M.CD_EMP IS NULL
		AND P.CD_EMP IS NULL
		AND E.CD_EMP=1
		AND E.CD_FILIAL=' +  convert(varchar, @CD_FILIAL) + '
		AND O.CALC_CUSTO_MEDIO=1 
		AND O.ATU_EST=1
		AND O.TP_ESTQ=0
		AND I.DT_ENT >= ''' + convert(varchar, @DiaCorte ) + '''
	GROUP BY 
		I.CD_EMP, 
		I.CD_FILIAL,
		I.CD_PROD;' 

	exec (@Cmd);


/*************************************************************************************************************************/
	if @debug=1
	begin
		Print 'Inicia carga das tabelas de processamento ' + convert(varchar,getdate(),108)
	end

	DECLARE @mensagemErro	varchar(250);
	DECLARE @severidadeErro int;
	DECLARE @estadoErro		int;

	SET @NMTBL = 'EST_FECHA_PROC_MOV_PEND_TBL_PROC_' +CONVERT(VARCHAR,@CD_FILIAL);

	IF not OBJECT_ID(@NMTBL) IS NULL
	begin
		SET @CMD = 'TRUNCATE TABLE ' + @NMTBL
		EXEC (@CMD);
	end

	IF OBJECT_ID(@NMTBL) IS NULL
		BEGIN
			SET @CMD = 'CREATE TABLE '  + @NMTBL + ' (CD_EMP INT, CD_FILIAL INT, CD_PROD INT, DT_PROC DATETIME,DT_PROC_FLUT DATETIME,
															CONSTRAINT PK_' + @NMTBL + ' PRIMARY KEY CLUSTERED (CD_PROD, CD_FILIAL, CD_EMP))';
		END
	ELSE
		BEGIN
			SET @CMD = 'TRUNCATE TABLE ' + @NMTBL
		END

	BEGIN TRY
		EXEC (@CMD);
	END TRY
	BEGIN CATCH  

		SELECT	@mensagemErro	= 'Falha atualizacao' + ERROR_MESSAGE(), 
				@severidadeErro = ERROR_SEVERITY(), 
				@estadoErro		= ERROR_STATE();
	 
		RAISERROR (@mensagemErro, @severidadeErro, @estadoErro); 
	END CATCH

/*************************************************************************************************************************/

	truncate table EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend;
		  
	if @debug=1
	begin
		PRINT 'Carrega pendencia de custo -  Time ' + CONVERT(VARCHAR, GETDATE (),108);
	end

	if @CD_PROD_PAR > 0 
	begin
	    INSERT INTO EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend
	    SELECT
		    CD_EMP,
		    CD_FILIAL,
		    CD_PROD,
		    dbo.F_DT_ULT_PROC_EST_FECHA_PROC_MOV(P.CD_EMP,P.CD_FILIAL,P.CD_PROD,P.DT_PROC),
		    null,
		    DT_CAD
	    from
		    EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p			
	    WHERE
		    CD_EMP =@CD_EMP
		    AND CD_FILIAL =@CD_FILIAL
		    AND CD_PROD =  @CD_PROD_PAR ;
    end 
    else
    begin
	   INSERT INTO EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend
	    SELECT
		    CD_EMP,
		    CD_FILIAL,
		    CD_PROD,
		    dbo.F_DT_ULT_PROC_EST_FECHA_PROC_MOV(P.CD_EMP,P.CD_FILIAL,P.CD_PROD,P.DT_PROC),
		    null,
		    DT_CAD
	    from
		    EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p
	    WHERE
		    CD_EMP =1
		    AND CD_FILIAL =@CD_FILIAL ; 

    end
		
	
	if @debug=1
	begin
		PRINT 'Realizando data de corte de processamento: ' + CONVERT(VARCHAR, @DT_ANO_INI,112) + '-  Time ' + CONVERT(VARCHAR, GETDATE (),108);
	end

	UPDATE
		EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend
	SET 
		DT_PROC=@DT_ANO_INI
	WHERE
		DT_PROC<=@DT_ANO_INI;

	UPDATE
		p
	SET
		p.DT_PROC = pend.dt_proc
	FROM
		EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p 
		INNER JOIN EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend pend on
		p.CD_EMP = pend.CD_EMP AND
		p.CD_FILIAL= pend.CD_FILIAL AND
		p.CD_PROD = pend.CD_PROD; 
	
	SET @DT_PROC_MIN=(SELECT MIN(DT_PROC) FROM EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend)

	IF NOT @DT_PROC_MIN IS NULL
	begin
		PRINT 'Data minima de processamento: ' + CONVERT(VARCHAR, @DT_PROC_MIN,112) + '-  Time ' + CONVERT(VARCHAR, GETDATE (),108);
	end
	else
	begin
		PRINT 'Nao possui data para processamento -  Time ' + CONVERT(VARCHAR, GETDATE (),108);
	end

	--Se existir pendencia para processar		
	IF EXISTS(SELECT CD_EMP  
				FROM EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend)	
	begin
		if @debug=1
		begin		  	
			PRINT 'Gerando tabela temporaria dos produtos -  Time ' + CONVERT(VARCHAR, GETDATE (),108);
		end

		begin try

			SET @CMD = 'INSERT INTO ' + @NMTBL + ' (CD_EMP,CD_FILIAL,CD_PROD,DT_PROC,DT_PROC_FLUT)'
			SET @CMD = @CMD + ' SELECT CD_EMP, CD_FILIAL, CD_PROD, DT_PROC,DT_PROC_FLUT FROM  EST_FECHA_PROC_MOV_FILIAL_PENDENTE_CustoPend GROUP BY CD_EMP,  CD_FILIAL, CD_PROD, DT_PROC,DT_PROC_FLUT';
			EXEC (@CMD);
		  
			/**********************************************************************************************************************/

			SET @DIA = @DT_PROC_MIN
			WHILE @DT_FIM >= @DIA
			BEGIN
				if @debug=1
				begin
					PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' -  Processando dia  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
				end

				EXECUTE dbo.P_EST_FECHA_PROC_MOV @CD_EMP, @CD_FILIAL, @DIA, 1, 0, 0,0,@debug;

				--Marcando ultima data de recalculo de custo medio
				EXEC dbo.P_EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO_INSERCAO @CD_EMP, @CD_FILIAL,0,@DIA;
	
				SELECT @DIA = @DIA + 1

				if @debug=1
				begin
					PRINT 'Alterando nova data tabela temporaria dos produtos ' + CONVERT(VARCHAR, @DIA, 112) + ' -  Time ' + CONVERT(VARCHAR, GETDATE (),108);
				end

				SET @CMD = 'UPDATE '+ @NMTBL + ' SET DT_PROC= ''' + CONVERT(VARCHAR, @DIA,112 ) + '''' 
				SET @CMD = @CMD + ' WHERE CD_EMP = ' + CONVERT(VARCHAR,@CD_EMP)
				SET @CMD = @CMD + ' AND CD_FILIAL = '  + CONVERT(VARCHAR, @CD_FILIAL)
				SET @CMD = @CMD + ' AND DT_PROC = ''' +  CONVERT(VARCHAR, DATEADD(DAY,-1, @DIA),112) + '''';
				
				EXEC (@CMD); 
				
				UPDATE EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE
				SET 
					DT_PROC=@DIA,
					DT_PROC_ATUAL=GETDATE()
				WHERE
					CD_EMP =@CD_EMP
					AND CD_FILIAL = @CD_FILIAL
					AND DT_PROC = @DIA-1; 
			END		

		/**********************************************************************************************************************/

			if @debug=1
			begin
				PRINT 'Deletando pendencia ja processada ' + CONVERT(VARCHAR, GETDATE (),108)
			end

			DELETE
				p
			FROM
				EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p 
			WHERE
				CD_EMP =@CD_EMP
				AND CD_FILIAL=@CD_FILIAL
				AND DT_PROC >=@DT_FIM;

			if @debug=1
			begin
				PRINT 'Deletando dados da tabela temporaria ' + CONVERT(VARCHAR, GETDATE (),108);
			end

			IF NOT OBJECT_ID(@NMTBL) IS NULL
			BEGIN
				SET @CMD = 'DROP TABLE ' + @NMTBL
				EXEC (@CMD);
			END
		end try
		begin catch

			if @debug=1
			begin
				Print 'Falha na geracao do custo medio Time ' + convert(varchar,getdate(),108) ;
			end

			--Registra erro na tabela de hist?rico de erros do banco Gestao			
			SELECT	@mensagemErro = ERROR_MESSAGE(), 
					@severidadeErro = ERROR_SEVERITY(), 
					@estadoErro = ERROR_STATE();

			INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
				SELECT
					ERROR_NUMBER() AS numero,
					@severidadeErro AS severidade,
					@estadoErro AS estado,
					ERROR_PROCEDURE() AS rotina,
					ERROR_LINE() AS linha,
					@mensagemErro AS mensagem,
					GETDATE() AS dtErro;

			RAISERROR (@mensagemErro, @severidadeErro, @estadoErro);
			RETURN -2;	  

		end catch 
	end

	if @Debug=1
	begin
		PRINT	'****** Fim - P_EST_FECHA_PROC_MOV_FILIAL_PENDENTE ******' + CONVERT(VARCHAR(8), GETDATE(), 108);
	end